<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('education_background', function (Blueprint $table) {
            $table->unsignedBigInteger('Education_id')->autoIncrement();
            $table->unsignedBigInteger('User_id');
            $table->string('Institution', 255);
            $table->string('Degree', 255);
            $table->string('Field_of_study', 255);
            $table->date('Start_date');
            $table->date('End_date')->nullable();
            $table->boolean('Currently_studying')->default(0);
            $table->text('Description')->nullable();
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Updated_at')->default(DB::raw('CURRENT_TIMESTAMP'))->onUpdate(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('User_id', 'education_background_user_id_foreign')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('education_background');
    }
};
